﻿namespace Hims.Api.Controllers
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The patients controller.
    /// </summary>
    [Route("api/exception-log")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class ExceptionLogController : BaseController
    {
        /// <summary>
        /// the audit log service
        /// </summary>
        private readonly IExceptionLogService exceptionLogService;

        /// <inheritdoc />
        public ExceptionLogController(IExceptionLogService exceptionLogService) => this.exceptionLogService = exceptionLogService;

        /// <summary>
        /// To fetch exception logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of exception logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of exception logs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("fetch")]
        [ProducesResponseType(typeof(IEnumerable<ExceptionLogModel>), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> FetchAsync([FromBody] ExceptionLogFilterModel model)
        {
            model = (ExceptionLogFilterModel)EmptyFilter.Handler(model);
            var exceptionLogs = await this.exceptionLogService.FetchAsync(model);
            if (exceptionLogs == null)
            {
                return ServerError();
            }

            return Success(exceptionLogs);
        }

        /// <summary>
        /// To resolve exception logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        [HttpPost]
        [Authorize]
        [Route("resolve")]
        [ProducesResponseType(typeof(string), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> ResolveAsync([FromBody] ExceptionLogFilterModel model)
        {
            model = (ExceptionLogFilterModel)EmptyFilter.Handler(model);
            var exceptionLogs = await this.exceptionLogService.ResolveAsync(model.ExceptionLogId);
            if (exceptionLogs == 0)
            {
                return ServerError();
            }

            return Success("Exception resolved successfully");
        }

        /// <summary>
        /// To fetch exception logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of exception logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of exception logs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        /// 
        [HttpPost]
        [Authorize]
        [Route("fetch-method")]
        [ProducesResponseType(typeof(IEnumerable<ExceptionLogModel>), 200)]
        [ProducesResponseType(500)]
        public async Task<ActionResult> GetMethodAsync([FromBody] ExceptionLogFilterModel model)
        {
           // model = (ExceptionLogFilterModel)EmptyFilter.Handler(model);
            var exceptionLogs = await this.exceptionLogService.GetMethodAsync(model.LogPath);
            if (exceptionLogs == null)
            {
                return ServerError();
            }

            return Success(exceptionLogs);
        }
        /// <summary>
        /// To fetch exception logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of exception logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of exception logs.
        /// - 500 - Problem with Server side code.
        ///// </remarks>
        [HttpPost]
        [Authorize]
        [Route("fetch-log-route")]
        [ProducesResponseType(typeof(IEnumerable<ExceptionLogModel>), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> GetLogRouteAsync()
        {
            var exceptionLogs = await this.exceptionLogService.GetLogRouteAsync();
            if (exceptionLogs == null)
            {
                return ServerError();
            }

            return Success(exceptionLogs);
        }

    }
}
